<?php
declare(strict_types=1);

function i18n_lang(): string {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  $allowed = ['pl','en','es'];
  $lang = $_GET['lang'] ?? $_SESSION['lang'] ?? ($_ENV['DEFAULT_LANG'] ?? 'es');
  $lang = strtolower((string)$lang);
  if (!in_array($lang, $allowed, true)) $lang = 'es';
  $_SESSION['lang'] = $lang;
  return $lang;
}

function i18n_load(string $lang): array {
  static $cache = [];
  if (isset($cache[$lang])) return $cache[$lang];

  $file = APP_ROOT . '/lang/' . $lang . '.json';
  if (!is_file($file)) return $cache[$lang] = [];
  $json = file_get_contents($file);
  $data = json_decode((string)$json, true);
  return $cache[$lang] = (is_array($data) ? $data : []);
}

function t(string $key, array $vars = []): string {
  $lang = i18n_lang();
  $dict = i18n_load($lang);
  $val = (string)($dict[$key] ?? $key);
  foreach ($vars as $k => $v) {
    $val = str_replace('{' . $k . '}', (string)$v, $val);
  }
  return $val;
}
