<?php
declare(strict_types=1);

function db(): PDO {
  static $pdo = null;
  if ($pdo instanceof PDO) return $pdo;

  $host = $_ENV['DB_HOST'] ?? 'localhost';
  $name = $_ENV['DB_NAME'] ?? '';
  $user = $_ENV['DB_USER'] ?? '';
  $pass = $_ENV['DB_PASS'] ?? '';
  $charset = $_ENV['DB_CHARSET'] ?? 'utf8mb4';

  if ($name === '' || $user === '') {
    throw new RuntimeException('DB config missing in .env');
  }

  $dsn = "mysql:host={$host};dbname={$name};charset={$charset}";
  $pdo = new PDO($dsn, $user, $pass, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
  return $pdo;
}
