<?php
declare(strict_types=1);

function user_permissions(): array {
  static $cache = null;
  if ($cache !== null) return $cache;

  $u = auth_user();
  if (!$u) return $cache = [];

  $pdo = db();
  $stmt = $pdo->prepare("
    SELECT DISTINCT p.slug
    FROM permissions p
    JOIN role_permissions rp ON rp.permission_id=p.id
    JOIN user_roles ur ON ur.role_id=rp.role_id
    WHERE ur.user_id=?
  ");
  $stmt->execute([(int)$u['id']]);
  $perms = [];
  foreach ($stmt->fetchAll() as $row) $perms[] = (string)$row['slug'];
  return $cache = $perms;
}

function can(string $perm): bool {
  $u = auth_user();
  if (!$u) return false;
  if (in_array('admin', $u['roles'] ?? [], true)) return true; // admin bypass
  return in_array($perm, user_permissions(), true);
}

function require_perm(string $perm): void {
  require_login();
  if (!can($perm)) {
    http_response_code(403);
    echo "Forbidden";
    exit;
  }
}
