<?php
declare(strict_types=1);

define('APP_ROOT', realpath(__DIR__ . '/../../') ?: (__DIR__ . '/../../'));

/**
 * Minimal .env loader (PHP 7.4+).
 * Reads .env from project root (same folder where /admin, /app, /lang exist).
 * We do NOT modify .env.
 */
$envFile = APP_ROOT . '/.env';
if (is_file($envFile)) {
  $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
  foreach ($lines as $line) {
    $line = trim($line);
    if ($line === '' || strpos($line, '#') === 0) continue;
    if (strpos($line, '=') === false) continue;
    [$k, $v] = explode('=', $line, 2);
    $k = trim($k);
    $v = trim($v);
    $v = trim($v, ""'");
    $_ENV[$k] = $v;
  }
}

$_ENV['APP_ENV']   = $_ENV['APP_ENV']   ?? 'prod';
$_ENV['APP_DEBUG'] = $_ENV['APP_DEBUG'] ?? '0';

if (($_ENV['APP_DEBUG'] ?? '0') === '1') {
  ini_set('display_errors', '1');
  error_reporting(E_ALL);
} else {
  ini_set('display_errors', '0');
}

require_once APP_ROOT . '/app/Core/db.php';
require_once APP_ROOT . '/app/Core/helpers.php';
require_once APP_ROOT . '/app/Core/csrf.php';
require_once APP_ROOT . '/app/Core/i18n.php';
require_once APP_ROOT . '/app/Core/auth.php';
require_once APP_ROOT . '/app/Core/acl.php';
